#Note: not all functions are being utilized, some were made 
#      for use if needed in future functionality.

import sys, math
from math import *
from decimal import *

# read in the commandline.  Look for at least three arguments

try:
    infilename = "Objects.dat"
	
except:
    print "This file does not exist!"; sys.exit(1)

ifile = open(infilename, 'r')    #open a file to read
ofile = open('Objects.js','w')      #open a file to write



# ---------------------------------------------------------------
# Function to find Eccentric Anomaly 
# @param e and M 
# @return E in degrees

def FindE (e,M):
    
    M = radians(M)
    E = [M]

    DeltaE = 100.0

    while (DeltaE > 1e-8):
        
        E.append(M + e * sin(E[-1]))
        DeltaE = abs(E[-1] - E[-2])

    return degrees(E[-1])

#Calculate the new M value at a different time
#@param initial M value, Semi-major axis, Epoch, and time to convert to
#@return The new M value for time t
def FindNewM(M,a,Epoch,t):

    return (M + Findn(a)*(t - Epoch))%360

#Calculate the mean motion of the body
#@param Semi-major axis
#@return the mean motion value
def Findn(a):

    return (.017202*180.0/pi)/sqrt(a**3)

#Calculate the True Anomaly of the body
#@param Eccentricity, Eccentricity Anomaly
#@return The True Anomaly value
def FindT(e,E):

    square = sqrt((1.0+e)/(1.0-e))
    tangent = tan(radians(E)/2.0)
    arcTangent = atan(square*tangent)
    T = degrees(2.0*arcTangent)    
    if (T < 0.0):
        T += 360
    return T

#Calculate the orbital position vector
#@param Semi-major axis, Eccenticity, and Eccentricity Anomaly
#@return orbital position vector
def Findr(a,e,E):

    r = a*(1.0 - e*cos(radians(E)))
    return r

#Calculate the orbital velocity
#@param orbital position vector, semi-major axis
#@return The orbital velocity
def Findv(r,a):

    v = sqrt((2.9591e-4)*((2.0/r) - (1.0/a)))*(149598000.0/86400.0)
    return v

#Calculate the X position of the body in cartesian coordinates
#@param Orbital position vector, Longitude of the ascending node, 
#       Argument of the perihelion, True Anomaly, Inclination
#@return The X coordinate in AU
def FindX(r,om,w,T,i):

    return r*(cos(om)*cos(w+T) - sin(om)*sin(w+T)*cos(i))

#Calculate the Y position of the body in cartesian coordinates
#@param Orbital position vector, Longitude of the ascending node, 
#       Argument of the perihelion, True Anomaly, Inclination
#@return The Y coordinate in AU
def FindY(r,om,w,T,i):

    return r*(sin(om)*cos(w+T) + cos(om)*sin(w+T)*cos(i))

#Calculate the Z position of the body in cartesian coordinates
#@param Orbital position vector, Argument of the perihelion, 
#       True Anomaly, Inclination
#@return The Z coordinate in AU
def FindZ(r,w,T,i):

    return r*sin(w+T)*sin(i)

#Calculate the rough diameter of Body
#@param Absolute Magnitude
#@return The Diameter
def GetDiameter(H):

    return 1329*10**(-0.2*H)/sqrt(0.09)

#Calculate the rough mass of the Body
#@param Diameter
#@return mass
def GetMass(D):

    return 3000/6*pi*D**3

# Here is the main part of the program where the datafile
# is read in and processed
def main():

    t = int(raw_input('Please enter a date in MJD:'))  #In MJD
 	
    ofile.write("var solar=[")
    for line in ifile:

        element = line.split()      # Each line of data file is split up
                                    # and assigned to a variable.

        #Declared Variables from file
        Epoch = int(element[0])
        a = float(element[1])
        e = float(element[2])
        i = radians(float(element[3]))  #Changed to radians
        om = radians(float(element[4])) #Changed to radians
        w = radians(float(element[5]))  #Changed to radians
        M = float(element[6])
        H = float(element[7])
        bodyType = element[8]
        name = element[9]
        

        #Static Variables
        Diam = GetDiameter(H)   #KiloMeters
        mass = GetMass(Diam*1000)  #kg

        ofile.write("[\"" + name + "\",\"" + bodyType + "\",\"" + str(Diam) + "\",\"" + str(mass) + "\",\"")

        #Non-Static Variables
        newM = FindNewM(M,a,Epoch,t)
        E = FindE(e,newM)
        T = radians(FindT(e,E))
        r = Findr(a,e,E)
        #v = Findv(r,a)
        X = FindX(r,om,w,T,i)   #AU
        Y = FindY(r,om,w,T,i)   #AU
        Z = FindZ(r,w,T,i)      #AU

        ofile.write(str(X) + "\",\"" + str(Y) + "\",\"" + str(Z) + "\"], ")


    ofile.write(']')

    ifile.close()          # close data file

if __name__ == "__main__": # Run the main program and exit
    main()
