/* rupcommand.c
 * Copyright (C) 1998 N.Fukase
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "rupcommand.h"
#include "rupserial.h"
/*
	gtime	Ļ֤μ
	stime	Ļ֤
	reset	ĥꥻåȽԤ

	format	ĥեåǥեޥåȤ
	chkdsk	ĥեåå
	gpower	Ľťͤμ
*/

/*----- Ƽ拾ѥޥ --------------------------------------------------*/
/* Ruputer Rshell ޥ */
#define RCOM_END	0
#define RCOM_COPY	1
#define RCOM_DEL	2
#define RCOM_DIR	3
#define RCOM_FORMAT	4
#define RCOM_REN	5
#define RCOM_RESET	6
#define RCOM_VER	7
#define RCOM_DOWNLOAD	8
#define RCOM_UPLOAD	9
#define RCOM_MKDIR	10
#define RCOM_RMDIR	11
#define RCOM_CHDIR	12
#define RCOM_GTIME	13
#define RCOM_STIME	14
#define RCOM_GPOWER	15
#define RCOM_CHKDSK	18

/*_____ debug print ________________________________________________________*/
#ifdef DEBUG
static inline void
debug_print(LENDAT *d)
{
  int	i;
  for (i = 0; i < d->length ; i++) {
    printf("%02x ", d->data[i] & 0xff);
  }
  printf("\n");
}
#else
static inline void
debug_print(LENDAT *d)
{
}
#endif
/*_____ ENDޥ ________________________________________________________*/
int
command_end(void)
{
  LENDAT data;

  if (ruputer_command(RCOM_END, 0, 4, NULL)) {
    return -1;
  }
  if(chk_ack())
    return -1;
  if (ruputer_response(RCOM_END, 0, &data) < 0) {
    fprintf(stderr, "bad data");
    return -1;
  }
  put_ack();
  debug_print(&data);
  free(data.data);
  return 0;
}
/*_____ DIRޥ ________________________________________________________*/
int
command_dir(RDENT *dent)
{
     LENDAT	buf;
     RFINFO	*rfi;
     int	seq = 1, nf = 0 , nfiles = 0, len, i, diskfree;
     char	path[64], *p;

     dent->nfiles = 0;
     len = strlen(dent->path) + 1;
     memcpy(path, dent->path, len);
     len += 4;
     if (ruputer_command(RCOM_DIR, 1, len, path))
	  return -1;
     if(chk_ack())
	  return -1;
     if (ruputer_response(RCOM_DIR, 1, &buf) < 0) {
	  fprintf(stderr, "1bad data");
	  return -1;
     }
     put_ack();
     debug_print(&buf);
     rfi = NULL;
     while(1) {
	  /* ǡå */
	  if (buf.length < 10) {
	       fprintf(stderr, "command: dir Bad Length\n");
	       free(buf.data);
	       free(rfi);
	       return -1;
	  }
	  p = buf.data;
	  if((WORD(p) != 0)) {
	       fprintf(stderr, "command: dir Bad Return Status\n");
	       free(buf.data);
	       free(rfi);
	       return -1;
	  }
	  p += 2;
	  if (WORD(p) != seq) {
	       fprintf(stderr, "command: dir Bad Sequence Number\n");
	       free(buf.data);
	       free(rfi);
	       return -1;
	  }
	  p += 2;
	  diskfree = DWORD(p);	p += 4;
	  nf = WORD(p);		p += 2;
	  rfi = (RFINFO *)realloc(rfi, (nfiles + nf) * sizeof(RFINFO));
	  /* ե򥳥ԡ */
	  for (i = nfiles, nfiles += nf; i < nfiles; ++i) {
	       rfi[i].ctime = WORD(p);		p += 2;
	       rfi[i].cdate = WORD(p);		p += 2;
	       rfi[i].size = DWORD(p);		p += 4;
	       rfi[i].attr = *p;			p++;
	       memcpy(rfi[i].name, p, 13);	p += 13;
	  }
	  free(buf.data);
	  if(nf < 5)
	       break;
	  /* ΥǡGET */
	  seq++;
	  if (ruputer_command(RCOM_DIR, 2, 4, NULL))
	       return -1;
	  if(chk_ack())
	       return -1;
	  if (ruputer_response(RCOM_DIR, 2, &buf) < 0) {
	       fprintf(stderr, "2bad data");
	       return -1;
	  }
	  put_ack();
	  debug_print(&buf);
     }
     dent->rfi = rfi;
     dent->nfiles = nfiles;
     return 0;
}
/*_____ VERޥ ________________________________________________________*/
int
command_ver(void)
{
     LENDAT	data;
     int		r;

     if (ruputer_command(RCOM_VER, 0, 4, NULL)) {
	  return -1;
     }
     if(chk_ack()) {
	  fprintf(stderr, "bad response\n");
	  return -1;
     }
     if (ruputer_response(RCOM_VER, 0, &data) < 0) {
	  fprintf(stderr, "bad data");
	  return -1;
     }
     put_ack();
     debug_print(&data);
     r = WORD(data.data + 2);
     free(data.data);
     return r;
}
/*_____ UPLOADޥ _____________________________________________________*/
int
command_upload(LENDAT *dat, RFINFO *rfi, char *path)
{
     LENDAT	data;
     unsigned char	buf[76];
     int		i;
  
     strcpy(buf + 2, path);
     strcat(buf + 2, rfi->name);
     printf("%s\n", buf + 2);
     i = strlen(buf + 2);	i++;
     WORD2(buf, i);		i += 2;
     DWORD2(buf + i, rfi->size); i += 4;
     WORD2(buf + i, rfi->ctime); i += 2;
     WORD2(buf + i, rfi->cdate); i += 2;
     buf[i] =  rfi->attr;	 i++;
     if (ruputer_command(RCOM_UPLOAD, 0, i + 4, buf)) {
	  fprintf(stderr, "bad command\\n");
	  return -1;
     }
     if(chk_ack()) {
	  fprintf(stderr, "bad response\n");
	  return -1;
     }
     if (ruputer_response(RCOM_UPLOAD, 0, &data) < 0) {
	  fprintf(stderr, "bad data");
	  return -1;
     }
     put_ack();
     debug_print(&data);
     xmodem_up(dat);
     free(data.data);
     return 0;
}
/*_____ DOWNLOADޥ ____________________________________________________*/
int
command_download(LENDAT *dat, RFINFO *rfi, char *path)
{
     int	i, ret;
     LENDAT	data;
     char	buf[64];
     
     strcpy(buf, path);
     strcat(buf, rfi->name);
     i = strlen(buf) + 5;
     dat->data = NULL;
     if (ruputer_command(RCOM_DOWNLOAD, 0, i, buf))
	  return -1;
     if(chk_ack())
	  return -1;
     if (ruputer_response(RCOM_DOWNLOAD, 0, &data) < 0) {
	  fprintf(stderr, "bad data");
	  return -1;
     }
     put_ack();
     debug_print(&data);
     ret = WORD(data.data);
     if (ret != 0)
	  return ret;
     rfi->size = DWORD(data.data + 2);
     rfi->ctime = WORD(data.data + 6);
     rfi->cdate = WORD(data.data + 8);
     rfi->attr = data.data[10];
     free(data.data);
     rfi->name[12] = '\0';
     if ((dat->data = (char *)malloc(rfi->size)) == NULL) {
	  fprintf(stderr, "Cannot allocate memory\n");
	  return -1;
     }
     dat->length = rfi->size;
     if (xmodem_down(dat)) {
	  dat->data = NULL;
	  fprintf(stderr, "Download failed\n");
	  return -1;
     }
     return 0;
}
/*_____ ե̾ĤΥޥ __________________________________________*/
static inline int
command_onefile(int command, char *dname)
{
     LENDAT data;
     int	i;
  
     i = strlen(dname) + 5;
     if (ruputer_command(command, 0, i, dname))
	  return -1;
     if(chk_ack())
	  return -1;
     if (ruputer_response(command, 0, &data) < 0) {
	  fprintf(stderr, "bad data");
	  return -1;
     }
     put_ack();
     debug_print(&data);
     i = WORD(data.data);
     free(data.data);
     return i;
}
/*_____ MKDIRޥ _______________________________________________________*/
int
command_mkdir(char *dname)
{
     return command_onefile(RCOM_MKDIR, dname);
}
/*_____ RMDIRޥ _______________________________________________________*/
int
command_rmdir(char *dname)
{
     return command_onefile(RCOM_RMDIR, dname);
}
/*_____ DELޥ _______________________________________________________*/
int
command_del(char *dname)
{
     return command_onefile(RCOM_DEL, dname);
}
/*_____ CHDIRޥ _______________________________________________________*/
int
command_chdir(char *dname)
{
     return command_onefile(RCOM_CHDIR, dname);
}

/*_____ ե̾2ĤΥޥ _____________________________________________*/
static inline int
command_twofiles(int command, char *new, char *old)
{
  LENDAT data;
  char buf[132];
  int	i, j;

  i = strlen(old) + 1;
  WORD2(buf, i);
  strcpy(buf + 4, old);
  i += 4;
  j = strlen(new) + 1;
  WORD2(buf + 2, j);
  strcpy(buf + i, new);
  if (ruputer_command(command, 0, (i + j + 4), buf))
    return -1;
  if(chk_ack())
    return -1;
  if (ruputer_response(command, 0, &data) < 0) {
    fprintf(stderr, "bad data");
    return -1;
  }
  put_ack();
  debug_print(&data);
  i = WORD(data.data);
  free(data.data);
  return i;
}
/*_____ RENޥ _________________________________________________________*/
int
command_ren(char *new, char *old)
{
  return command_twofiles(RCOM_REN, new, old);
}
/*_____ COPYޥ ________________________________________________________*/
int
command_copy(char *new, char *old)
{
  return command_twofiles(RCOM_COPY, new, old);
}
