/* rupcommand.h
 * Copyright (C) 1998 N.Fukase
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA
 */

/*_____ ɤǸ褦ޥ ________________________________________*/
#define WORD(b)		(((b)[0] & 0xff) + (((b)[1] & 0xff) << 8))
#define DWORD(b)	(((b)[0] & 0xff) + (((b)[1] & 0xff) << 8) +\
			(((b)[2] & 0xff) << 16) + (((b)[3] & 0xff) << 24))

#define WORD2(b,c)	(((b)[0] = (c & 0xff)), \
			 ((b)[1] = ((c & 0xff00) >> 8)))
#define DWORD2(b,c)	(((b)[0] = (c & 0xff)),\
			 ((b)[1] = ((c & 0xff00) >> 8)),\
			 ((b)[2] = ((c & 0xff0000) >> 16)), \
			 ((b)[3] = ((c & 0xff000000) >> 24)))

/*----- ̣ι¤s ------------------------------------------------------*/
/* Ruputerե */
typedef struct {
  unsigned short	ctime,
			cdate;
  unsigned		size;
  unsigned char		attr;
  char			name[13];
} RFINFO;

/* ǥ쥯ȥꥨȥ */
typedef struct {
  int			nfiles;
  RFINFO		*rfi;
  char			path[64];
} RDENT;

/* ХʥǡȤΥǡĹ */
typedef struct {
  int	length;
  char	*data;
} LENDAT;

/*-----  ------------------------------------------------------*/
extern int command_end(void);
extern int command_dir(RDENT *dent);
extern int command_ver(void);
extern int command_upload(LENDAT *dat, RFINFO *rfi, char *path);
extern int command_download(LENDAT *dat, RFINFO *rfi, char *path);
extern int command_mkdir(char *dname);
extern int command_rmdir(char *dname);
extern int command_del(char *dname);
extern int command_chdir(char *dname);
extern int command_ren(char *new, char *old);
extern int command_copy(char *new, char *old);
