class Matrix:
    def __init__(self, p, n, entries=None):
        """
        Create a matrix over a finite field.
        INPUT:
            p -- prime
            n -- positive integer
            entries -- entries of the matrix (defaults to None, which means 0 matrix).
        """
        self.__n = n
        self.__p = p
        if entries != None:
            self.__entries = [x % p for x in entries]
        else:
            self.__entries = [0 for _ in range(n*n)]
            
    def __repr__(self):
        s = ""
        n = self.__n
        for i in range(n):
            for j in range(n):
                s += "%s, "%self.__entries[n*i + j]
            s += "\n"
        return s
    
    def __mul__(self, other):
        assert isinstance(other, Matrix) and \
               self.__p == other.__p and \
               self.__n == other.__n, "Incompatible multiply."
        ans = []
        n = self.__n
        for i in range(n):
            for j in range(n):
                # The i,j entry of the product
                v = [self.__entries[i*n+k] * other.__entries[k*n+j] for k in range(n)]
                ans.append(sum(v) % self.__p)
        return Matrix(self.__p, n, ans)

