import timeit

def matmul(tries=10, p=97, n=20):
    T0 = timeit.Timer("a=mult1.Matrix(%s,%s,range(%s*%s)); a*a"%\
                      (p,n,n,n), "import mult1")
    T1 = timeit.Timer("a=mult2.Matrix(%s,%s,range(%s*%s)); a*a"%\
                      (p,n,n,n), "import mult2")
    T2 = timeit.Timer("a=mult3.Matrix(%s,%s,range(%s*%s)); a*a"%\
                      (p,n,n,n), "import mult3")
    t0 = T0.timeit(tries)
    t1 = T1.timeit(tries)
    t2 = T2.timeit(tries)
    print "Pure Python: %s\nPyrex: %s (Speedup: %s)"%(t0, t1, t0/t1)
    print "Psyco: %s (Speedup: %s)"%(t2, t0/t2)

